/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
*****************************************************************************/

/*!*********************************************************************************
*  @file    apu_add_process_controller_policy.hpp
*  @brief   Policy for APEX2 process controller data
***********************************************************************************/

#ifndef APUADDPROCESSCONTROLLERPOLICY_HPP
#define APUADDPROCESSCONTROLLERPOLICY_HPP

#include <stdio.h>
#include <opencv2/opencv.hpp>
#include <umat.hpp>

#ifdef APEX2_EMULATE
#include "apu_app_config.hpp"
#endif

namespace apugen {

class AddInput0ConversionPolicy
{
protected:
  void Conversion(uint8_t** aSource, vsdk::UMat& aGraphDescr)
  {
    vsdk::Mat lMat = aGraphDescr.getMat(OAL_USAGE_CACHED);
    uint8_t * lpData = *aSource;

    for (int i = 0; i < lMat.rows; i++)
    {
      for (int j = 0; j < lMat.cols; j++)
      {
        lMat.at<uint8_t>(i, j) = static_cast<uint8_t>(*lpData++);
      }
    }
  }
};


class AddInput1ConversionPolicy
{
protected:
  void Conversion(uint8_t** aSource, vsdk::UMat& aGraphDescr)
  {
    vsdk::Mat lMat = aGraphDescr.getMat(OAL_USAGE_CACHED);
    uint8_t * lpData = *aSource;

    for (int i = 0; i < lMat.rows; i++)
    {
      for (int j = 0; j < lMat.cols; j++)
      {
        lMat.at<uint8_t>(i, j) = static_cast<uint8_t>(*lpData++);
      }
    }
  }
};


class AddOutput0ConversionPolicy
{
protected:
  void Conversion(uint16_t** aSink, vsdk::UMat& aGraphDescr)
  {
    vsdk::Mat lMat = aGraphDescr.getMat(OAL_USAGE_CACHED);
    uint16_t * lpData = *aSink;

    for (int i = 0; i < lMat.rows; i++)
    {
      for (int j = 0; j < lMat.cols; j++)
      {
        *lpData++ = static_cast<uint16_t>(lMat.at<uint16_t>(i, j));
      }
    }
  }
};

}  /* namespace apugen */
#endif /* APUADDPROCESSCONTROLLERPOLICY_HPP */
